<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 250);
			$table->string('email');
			$table->string('last_name', 250);
			$table->enum('gender', array('male', 'female'));
			$table->string('role');
			$table->enum('status', array('active', 'inActive'));
			$table->bigInteger('branch_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}