<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 255);
			$table->string('last_name', 250);
			$table->string('email', 50);
			$table->timestamps();
			$table->bigInteger('tenant_id');
			$table->enum('type', array('user', 'superAdmin'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}