<?php

namespace App\Models;

class Branch extends Eloquent {

	protected $table = 'branches';
	public $timestamps = true;

	public function services()
	{
		return $this->hasMany('Service', 'branch_id');
	}

	public function bookings()
	{
		return $this->hasMany('Booking', 'booking_id');
	}

	public function admins()
	{
		return $this->hasMany('Employee', 'admin_id');
	}

	public function addresses()
	{
		return $this->morphMany('Address', 'addressable');
	}

	public function phones()
	{
		return $this->morphMany('Phone', 'phoneable');
	}

}