<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Filter extends Eloquent {

	protected $table = 'filters';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'type', 'filter_recurring_id', 'category_id');

	public function subAccounts()
	{
		return $this->belongsToMany('App\Models\SubAccount', 'filter_sub_accounts');
	}

	public function subFilters()
	{
		return $this->hasMany('App\Models\SubFilter');
	}

	public function filterRecurring()
	{
		return $this->belongsTo('App\Models\FilterRecurring', 'filter_recurring_id');
	}

	public function category()
	{
		return $this->belongsTo('App\Models\Category');
	}

}