<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FilterRecurring extends Eloquent {

	protected $table = 'filters_recurring';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function filters()
	{
		return $this->hasMany('App\Models\Filter', 'filter_recurring_id');
	}

	public function subFiltersRecurring()
	{
		return $this->hasMany('App\Models\SubFilterRecurring');
	}

	public function subAccounts()
	{
		return $this->belongsToMany('App\Models\SubAccount', 'filter_reccuring_sub_accounts');
	}

}