<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SubFilter extends Eloquent {

	protected $table = 'sub_filters';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'filter_id', 'recurring_sub_filter_id');

	public function filter()
	{
		return $this->belongsTo('App\Models\Filter');
	}

	public function recurringSubFilter()
	{
		return $this->belongsTo('App\Models\SubFilterRecurring');
	}

}