<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('delivery_date', 'user_id', 'client_id', 'address_id', 'driver_id', 'store_id', 'payment_id', 'status', 'sub_total', 'delivery_fees', 'total', 'discount_id', 'from', 'to', 'note', 'client_rate', 'store_rate', 'driver_rate', 'review');

    public function products()
    {
        return $this->hasMany('OrderProduct', 'order_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

    public function store()
    {
        return $this->belongsTo('Store', 'store_id');
    }

    public function payment()
    {
        return $this->belongsTo('StorePayment', 'payment_id');
    }

    public function driver()
    {
        return $this->belongsTo('Driver', 'driver_id');
    }

    public function discount()
    {
        return $this->belongsTo('Discount', 'discount_id');
    }

    public function address()
    {
        return $this->belongsTo('Address', 'address_id');
    }

}