<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderProduct extends Model 
{

    protected $table = 'order_product';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'product_id', 'price');

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function product()
    {
        return $this->belongsTo('Product', 'product_id');
    }

    public function order_options()
    {
        return $this->hasMany('OrderOption', 'order_product_id');
    }

}