<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductOption extends Model 
{

    protected $table = 'product_option';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('product_id', 'option_category_id', 'option_id', 'price');

    public function product()
    {
        return $this->belongsTo('Product', 'product_id');
    }

    public function option_category()
    {
        return $this->belongsTo('OptionCategory', 'option_category_id');
    }

    public function option()
    {
        return $this->belongsTo('Option', 'option_id');
    }

}