<?php

namespace Customer;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Customer extends Eloquent {

	protected $table = 'customers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'address', 'phone', 'deposit_balance', 'added_balance', 'created_by', 'deleted_by', 'updated_by', 'customer_type_id');

	public function customer_type()
	{
		return $this->belongsTo('CustomerType\CustomerType', 'customer_type_id');
	}

	public function customer_balance_adjustments()
	{
		return $this->hasMany('CustomerBalanceAdjustments\CustomerBalanceAdjustments');
	}

}