<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('picture', function(Blueprint $table) {
			$table->foreign('id_galeri')->references('id')->on('galeri')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('skema_info', function(Blueprint $table) {
			$table->foreign('id_skema')->references('id')->on('skema')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('skema_biaya', function(Blueprint $table) {
			$table->foreign('id_skema')->references('id')->on('skema')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('arsip_asesmen', function(Blueprint $table) {
			$table->foreign('id_form')->references('id')->on('formulir')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('picture', function(Blueprint $table) {
			$table->dropForeign('picture_id_galeri_foreign');
		});
		Schema::table('skema_info', function(Blueprint $table) {
			$table->dropForeign('skema_info_id_skema_foreign');
		});
		Schema::table('skema_biaya', function(Blueprint $table) {
			$table->dropForeign('skema_biaya_id_skema_foreign');
		});
		Schema::table('arsip_asesmen', function(Blueprint $table) {
			$table->dropForeign('arsip_asesmen_id_form_foreign');
		});
	}
}