<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'password', 'phone', 'last_donation_date', 'd_o_b', 'blood_type_id', 'city_id');
    protected $hidden = array('password', 'api_token');

    public function bloodType()
    {
        return $this->belongsTo('App/Models\BloodType');
    }

    public function city()
    {
        return $this->belongsTo('App/Models\City');
    }

    public function donationRequest()
    {
        return $this->hasMany('App/Models\DonationRequest');
    }

    public function posts()
    {
        return $this->belongsToMany('App/Models\Post');
    }

    public function notifications()
    {
        return $this->belongsToMany('App/Models\Notification');
    }

}