<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEpisodeTagTable extends Migration {

	public function up()
	{
		Schema::create('Episode_Tag', function(Blueprint $table) {
			$table->increments('Id', true);
			$table->integer('TagId')->unsigned();
			$table->integer('EpisodeId')->unsigned();
			$table->timestamp('created_at');
			$table->timestamp('updated_at')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Episode_Tag');
	}
}