<?php

namespace shop.Episode_Tag;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Episode_Tag extends Model 
{

    protected $table = 'Episode_Tag';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('Id', 'EpisodeId', 'created_at');

    public function tags()
    {
        return $this->belongsToMany('Episodes');
    }

    public function episodes()
    {
        return $this->belongsToMany('Tags');
    }

}