<?php

namespace shop.Basket_Episode;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Basket_Episode extends Eloquent {

	protected $table = 'Basket_Episode';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('Id', 'BasketId', 'EpisodeId', 'TotalPrice', 'created_at');

	public function baskets()
	{
		return $this->belongsToMany('Episodes');
	}

	public function episodes()
	{
		return $this->belongsToMany('Baskets');
	}

}