<?php

namespace shop.Discount_Episode;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Discount_Episode extends Eloquent {

	protected $table = 'Discount_Episode';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('Id', 'EpisodeId', 'DiscountId', 'created_at');

	public function discounts()
	{
		return $this->belongsToMany('Episodes');
	}

	public function episodes()
	{
		return $this->belongsToMany('Discounts');
	}

}