<?php

namespace shop.Episode_Tag;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Episode_Tag extends Eloquent {

	protected $table = 'Episode_Tag';
	public $timestamps = false;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('Id', 'EpisodeId', 'created_at');

	public function tags()
	{
		return $this->belongsToMany('Episodes');
	}

	public function episodes()
	{
		return $this->belongsToMany('Tags');
	}

}