<?php

namespace shop.Episode_User;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Episode_User extends Eloquent {

	protected $table = 'Episode_User';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('Id', 'UserId', 'EpisodeId', 'created_at');

	public function users()
	{
		return $this->belongsToMany('Episodes');
	}

	public function episodes()
	{
		return $this->belongsToMany('Users');
	}

}