<?php

namespace shop.Payment_Episode;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Payment_Episode extends Eloquent {

	protected $table = 'Payment_Episode';
	public $timestamps = false;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('Id', 'PayId', 'EpisodeId', 'created_at');

	public function episodes()
	{
		return $this->belongsToMany('Payments');
	}

	public function payments()
	{
		return $this->belongsToMany('Episodes');
	}

}