<?php

namespace shop.Users;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Users extends Eloquent {

	protected $table = 'Users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('Id', 'Full_name', 'Email', 'Mobile', 'IP', 'created_at');

	public function commentable()
	{
		return $this->morphTo();
	}

	public function basket()
	{
		return $this->belongsTo('Baskets');
	}

}