<?php

namespace shop.Users;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Users extends Model 
{

    protected $table = 'Users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('Id', 'Full_name', 'Email', 'Mobile', 'IP', 'created_at');

    public function commentable()
    {
        return $this->morphTo();
    }

    public function basket()
    {
        return $this->belongsTo('Baskets');
    }

}