<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBasketEpisodeTable extends Migration {

	public function up()
	{
		Schema::create('Basket_Episode', function(Blueprint $table) {
			$table->increments('Id', true);
			$table->integer('BasketId')->unsigned();
			$table->integer('EpisodeId')->unsigned();
			$table->smallInteger('Quantity')->default('1');
			$table->string('TotalPrice');
			$table->timestamps();
			$table->timestamp('updated_at')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Basket_Episode');
	}
}