<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Arbitrator extends Model 
{

    protected $table = 'arbitrators';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'qualifications', 'experiences', 'ways_ids', 'qiraat_ids', 'rewayat_ids', 'is_teacher', 'egazat', 'softDeletes');

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function competitions()
    {
        return $this->belongsToMany('App\Models\Competition');
    }

}