<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;

class Country extends Model 
{

    protected $table = 'countries';
    public $timestamps = true;
    protected $fillable = array('name', 'code');

    public function users()
    {
        return $this->hasMany('App\Models\User', 'country_id');
    }

    public function cities()
    {
        return $this->hasMany('App/Models\City', 'country_id');
    }

    public function governrates()
    {
        return $this->hasMany('App/Models\Governrate', 'country_id');
    }

}