<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCaptainCarsTable extends Migration {

	public function up()
	{
		Schema::create('captain_cars', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('car_brand_id');
			$table->integer('car_model_id');
			$table->string('car_color_id');
			$table->date('car_year_date');
			$table->string('plate_number');
			$table->string('car_type');
			$table->string('plate_letters');
			$table->date('form_expiration_date');
			$table->date('insurance_expiry_date');
			$table->date('periodic_examination_end_date');
			$table->integer('captain_id');
		});
	}

	public function down()
	{
		Schema::drop('captain_cars');
	}
}