<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->double('subtotal_price');
			$table->double('total_price');
			$table->timestamps();
			$table->datetime('paid_at');
			$table->string('type');
			$table->string('status');
			$table->string('payment_method');
			$table->string('source_coordinates');
			$table->string('destination_coordinates');
			$table->string('distance');
			$table->time('time');
			$table->json('user_address');
			$table->string('source_address');
			$table->string('destination_address');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}