<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_subscriptions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_subscriptions', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->dropForeign('user_addresses_user_id_foreign');
		});
		Schema::table('user_subscriptions', function(Blueprint $table) {
			$table->dropForeign('user_subscriptions_user_id_foreign');
		});
		Schema::table('user_subscriptions', function(Blueprint $table) {
			$table->dropForeign('user_subscriptions_package_id_foreign');
		});
	}
}