<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntreprisesTable extends Migration {

	public function up()
	{
		Schema::create('entreprises', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('id_NMadmin')->unsigned()->nullable();
			$table->string('slug', 255)->nullable();
			$table->string('name', 255)->nullable();
			$table->string('logo', 255)->nullable();
			$table->string('logo2', 255)->nullable();
			$table->string('favicon', 255)->nullable();
			$table->string('defaultTheme', 255)->nullable();
			$table->string('notificationSeuilStock', 10)->nullable()->default('0');
			$table->integer('sante_type_depense')->nullable();
			$table->integer('achat_aliment_type_depense')->nullable();
			$table->integer('caisseTotal')->nullable()->default('0');
			$table->timestamp('dateFin')->nullable();
			$table->integer('nombreUtilisateur')->nullable();
			$table->integer('nombreVague')->nullable();
			$table->string('statut', 10)->default('0');
		});
	}

	public function down()
	{
		Schema::drop('entreprises');
	}
}