<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEspecesTable extends Migration {

	public function up()
	{
		Schema::create('especes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('slug', 255)->nullable();
			$table->integer('id_espece')->unsigned()->nullable();
			$table->integer('id_entreprise')->unsigned()->nullable();
			$table->string('nom', 255)->nullable();
			$table->string('description', 255)->nullable();
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('especes');
	}
}