<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMouvementsStocksTable extends Migration {

	public function up()
	{
		Schema::create('mouvements_stocks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->timestamp('date')->nullable();
			$table->softDeletes();
			$table->string('slug', 255)->nullable();
			$table->integer('id_depense')->unsigned()->nullable();
			$table->integer('id_aliment')->unsigned();
			$table->integer('id_utilisateur')->unsigned()->nullable();
			$table->decimal('effectif')->nullable();
			$table->string('motif', 255)->nullable();
			$table->text('commentaire')->nullable();
			$table->string('origine', 255)->nullable();
			$table->integer('prix')->nullable();
			$table->string('type', 255)->nullable();
			$table->string('equivalence_fait')->nullable()->default('0');
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('mouvements_stocks');
	}
}