<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingMealsTable extends Migration {

	public function up()
	{
		Schema::create('booking_meals', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('booking_id')->unsigned()->index();
			$table->integer('meal_type_id')->unsigned()->index();
			$table->date('date_meal')->index();
			$table->time('timing')->index();
			$table->integer('nbr_adults')->default('0');
			$table->integer('nbr_children')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('booking_meals');
	}
}