<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Answer extends Eloquent {

	protected $table = 'answers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('question_id', 'value', 'user_id', 'order_Id');

	public function question()
	{
		return $this->belongsTo('Question');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function order()
	{
		return $this->belongsTo('Order');
	}

}