<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Attachment extends Eloquent {

	protected $table = 'attachments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'path', 'question_id', 'user_id', 'order_Id');

	public function order()
	{
		return $this->belongsTo('Order');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function question()
	{
		return $this->belongsTo('Question');
	}

}