<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Section extends Eloquent {

	protected $table = 'sections';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_type_id', 'group_id', 'name', 'order', 'is_visible');

	public function order_type()
	{
		return $this->belongsTo('OrderType');
	}

	public function questions()
	{
		return $this->hasMany('Question');
	}

	public function group()
	{
		return $this->belongsTo('Group');
	}

}