<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->text('content')->nullable();
			$table->enum('type', array('Text', 'Number', 'Radio', 'Select', 'Date'));
			$table->integer('is_required');
			$table->text('placeholder');
			$table->bigInteger('regex_id')->unsigned();
			$table->bigInteger('section_id')->unsigned();
			$table->integer('is_visible')->default('1');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order');
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}