<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRegexesTable extends Migration {

	public function up()
	{
		Schema::create('regexes', function(Blueprint $table) {
			$table->increments('id');
			$table->text('name');
			$table->longText('description')->nullable();
			$table->string('regex', 255)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('regexes');
	}
}