<?php

namespace App;

class Book extends Eloquent {

	protected $table = 'books';
	public $timestamps = true;
	protected $fillable = array('name', 'annotation', 'isbn', 'publisher_id', 'publish_year', 'citation', 'pages', 'chapters', 'category_id', 'picture');

	public function category()
	{
		return $this->belongsTo('Category', 'id');
	}

	public function authors()
	{
		return $this->belongsToMany('Author', 'id');
	}

	public function genres()
	{
		return $this->belongsToMany('Genre', 'id');
	}

	public function tags()
	{
		return $this->belongsToMany('Tag', 'id');
	}

	public function values()
	{
		return $this->hasMany('PropsTypeValue');
	}

	public function publisher()
	{
		return $this->hasOne('Publisher');
	}

	public function tags()
	{
		return $this->belongsToMany('BookTag', 'tag_id');
	}

	public function cards()
	{
		return $this->belongsToMany('ReaderCard', 'id');
	}

}