<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('narrator_id')->references('id')->on('narrators')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('document_carrier')->references('id')->on('narrator_carrier')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('document_photos', function(Blueprint $table) {
			$table->foreign('document_id')->references('id')->on('documents')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('narrator_carrier', function(Blueprint $table) {
			$table->foreign('narrator_id')->references('id')->on('narrators')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('document_feature', function(Blueprint $table) {
			$table->foreign('document_id')->references('id')->on('documents')
						->onDelete('set null')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_narrator_id_foreign');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_area_id_foreign');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_city_id_foreign');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_document_carrier_foreign');
		});
		Schema::table('document_photos', function(Blueprint $table) {
			$table->dropForeign('document_photos_document_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_area_id_foreign');
		});
		Schema::table('narrator_carrier', function(Blueprint $table) {
			$table->dropForeign('narrator_carrier_narrator_id_foreign');
		});
		Schema::table('document_feature', function(Blueprint $table) {
			$table->dropForeign('document_feature_document_id_foreign');
		});
	}
}