<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('state_id')->unsigned();
			$table->integer('package_type_id')->unsigned();
			$table->integer('duration')->default('7');
			$table->string('slug');
			$table->string('name');
			$table->boolean('is_active')->default(1);
			$table->boolean('is_school_only')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}