<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePurchasesTable extends Migration {

	public function up()
	{
		Schema::create('purchases', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('package_id')->unsigned();
			$table->float('total');
			$table->integer('coupon_id')->nullable();
			$table->text('notes')->nullable();
			$table->json('webhook_data')->nullable();
			$table->timestamp('expires_on');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('purchases');
	}
}