<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAuctionsTable extends Migration {

	public function up()
	{
		Schema::create('auctions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->string('serial_number', 255)->nullable();
			$table->integer('sub_category_id')->index();
			$table->integer('category_id')->index();
			$table->date('start_date');
			$table->time('start_time')->nullable();
			$table->boolean('close_automaticaly')->default(false);
			$table->integer('close_duration')->nullable();
			$table->double('close_price')->nullable();
			$table->boolean('allow_promocodes')->default(false);
			$table->decimal('biding_gap_amount')->nullable();
			$table->integer('estimated_delivery_time')->nullable();
			$table->integer('shiping_amount_type')->nullable();
			$table->double('estimated_shipping')->nullable();
			$table->integer('type')->nullable();
			$table->integer('user_id')->nullable();
			$table->bigInteger('approval')->default('false');
			$table->integer('delivery_status')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('auctions');
	}
}