<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->string('app_name', 255)->nullable();
			$table->string('app_logo', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->text('bank_information')->nullable();
			$table->integer('payment_max_dur_confirm')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}