<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('serial_number', 255)->nullable();
			$table->integer('auction_id')->index();
			$table->integer('user_id')->nullable();
			$table->datetime('transaction_date')->nullable();
			$table->integer('transaction_type')->nullable();
			$table->integer('payment_methods_id')->nullable();
			$table->double('amount')->nullable();
			$table->double('payment_processing')->nullable();
			$table->double('shipping_fees')->nullable();
			$table->double('total_amount')->nullable();
			$table->softDeletes();
			$table->integer('promocode_id')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}