<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->string('mobile', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->integer('role_id')->index();
			$table->integer('type')->nullable()->default('1');
			$table->integer('country_id')->index();
			$table->boolean('activation_status')->default(false);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}