<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorsTable extends Migration {

	public function up()
	{
		Schema::create('doctors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 50);
			$table->string('email', 50)->unique();
			$table->boolean('certificate')->default(0);
			$table->string('password', 50);
			$table->string('license_no', 50)->unique();
			$table->string('job_title', 50);
			$table->string('description', 300);
			$table->smallInteger('session_price')->unsigned();
			$table->boolean('active')->default(1);
			$table->tinyInteger('rate')->default('3');
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('doctors');
	}
}