<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserDetailsTable extends Migration {

	public function up()
	{
		Schema::create('user_details', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('user_id')->unsigned();
			$table->string('identity', 255)->nullable();
			$table->integer('bank_id')->nullable();
			$table->string('bank_account', 255)->nullable();
			$table->string('bank_account_name', 255)->nullable();
			$table->string('phone', 255)->nullable();
			$table->date('birth')->nullable();
			$table->string('address', 255)->nullable();
			$table->string('photo', 255)->nullable();
			$table->char('gender', 1)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_details');
	}
}