<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class City extends Eloquent {

	protected $table = 'cities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_ar', 'name_en', 'is_active', 'country_id');

	public function country()
	{
		return $this->belongsTo('Country');
	}

	public function districts()
	{
		return $this->hasMany('District');
	}

}