<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class File extends Eloquent {

	protected $table = 'files';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('model_type', 'model_id', 'path', 'tag', 'file_name', 'notes', 'order', 'is_active', 'softDeletes');

	public function modelable()
	{
		return $this->morphTo();
	}

}