<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Location extends Eloquent {

	protected $table = 'locations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('lat', 'lng', 'is_active', 'map', 'model_id', 'model_type');

	public function modelable()
	{
		return $this->morphTo();
	}

}