<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Page extends Eloquent {

	protected $table = 'pages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_ar', 'name_en', 'description_ar', 'description_en', 'is_active', 'type', 'model_type');

	public function files()
	{
		return $this->morphMany('File', 'model');
	}

}